<?php


if (!defined('ABSPATH')) {
    die;
}

//使用Font Awesome 4
add_filter('csf_fa4', '__return_true');

function zibpost_csf_add_custom_wp_enqueue()
{
    // Style
    wp_enqueue_style('csf_custom_css',zibposturl.'/csf-framework/assets/css/style.min.css',array(), '2.0.0');
    // Script
    wp_enqueue_script('csf_custom_js',zibposturl. '/csf-framework/assets/js/main.min.js', array('jquery'), '2.0.0');
    // @wp_enqueue_script('tuisong.js',plugins_url( '/images/tuisong.js' , dirname(__FILE__) ), array('tuisong'), THEME_VERSION);
}
add_action('csf_enqueue', 'zibpost_csf_add_custom_wp_enqueue',1);

function zibpost_get_admin_csf_auth_url($tab = '')
{
	$tab                = trim(strip_tags($tab));
	$tab_array          = explode("/", $tab);
	$tab_array_sanitize = array();
	foreach ($tab_array as $tab_i) {
		$tab_array_sanitize[] = sanitize_title($tab_i);
	}
	$tab_attr = esc_attr(implode("/", $tab_array_sanitize));
	$url      = add_query_arg('page', 'zibpost', admin_url('admin.php'));
	$url      = $tab ? $url . '#tab=' . $tab_attr : $url;
	return esc_url($url);
}

function _zibposts($name, $default = false, $subname = '')
{
    static $options = null;
    if ($options === null) {
        $options = get_option('zibpost');
    }

    if (isset($options[$name])) {
        if ($subname) {
            return isset($options[$name][$subname]) ? $options[$name][$subname] : $default;
        } else {
            return $options[$name];
        }
    }
    return $default;
}

function _zibpost($name, $value)
{
    $get_option        = get_option('zibpost');
    $get_option        = is_array($get_option) ? $get_option : array();
    $get_option[$name] = $value;
    return update_option('zibpost', $get_option);
}

if (!function_exists('of_get_posts_meta')) 
{
    function of_get_posts_meta($name, $key, $default = false, $post_id = '')
    {
        global $post;
        $post_id  = $post_id ? $post_id : $post->ID;
        $get_mate = get_post_meta($post_id, $name, true);
        if (isset($get_mate[$key])) {
            return $get_mate[$key];
        }
        return $default;
    }
}

function card_report() 
{
    add_menu_page('推广管理', '推广管理', 'administrator', 'mk_activitys', 'mk_admin_activitys', 'dashicons-admin-generic', 100);
    add_submenu_page('mk_activitys', '推广管理', '推广管理', 'administrator', 'mk_activitys', 'mk_admin_activitys');
}
add_action('admin_menu', 'card_report');

function mk_admin_activitys()
{
    include  'admin-activitys.php';
}
