<?php
/*
plugin name: 易采集5.0
plugin URI: https://www.16yc.cn/
description: 易采集-全网的虚拟资源，每天自动同步到自己网站，解决站长到处找资源的烦恼，以及节省站长的宝贵的时间
author: 易创网
author URI: https://www.16yc.cn/
version: 5.0.0
*/

if (!defined('ABSPATH')) {
    die;
}

if (class_exists('CSF')) 
{
    $prefix = 'zibpost';

    CSF::createOptions($prefix, array(
        'menu_title' => '易采集',
        'menu_slug' => 'zibpost',
        'framework_title' => '易采集',
        'show_in_customizer' => true, //在wp-customize中也显示相同的选项
        'footer_text' => '由易创网开发的采集文章项目',
        'footer_credit' => '<i class="fa fa-fw fa-heart-o" aria-hidden="true"></i> ',
        'theme' => 'light',
    ));

    // 调试输出当前选项
    $options = get_option($prefix);
    error_log('Current Options: ' . print_r($options, true)); // 添加调试输出

    CSF::createSection($prefix, array(
        'id' => 'posts',
        'title' => '对接&配置',
        'icon' => 'fa fa-link'
    ));
    

CSF::createSection($prefix, array(
    'id'    => 'collection_config',
    'title' => '采集&配置',
    'parent' => 'posts', 
    'icon'  => 'fa fa-cog',
    'fields' => array(
        array(
                'content' => '<h3 style="color:#fd4c73;"><i class="fa fa-heart fa-fw"></i> 感谢您使用易采集</h3>
                <div style="margin: 10px 14px;">
                <li>本页面由易创技术网制作，请在使用时遵守原作者的版权规定</li>
                <li>官网：<a target="_bank" href="https://www.16yc.cn/">https://www.16yc.cn/</a></li>
                <li>作者联系方式：<a target="_bank" href="http://wpa.qq.com/msgrd?v=3&amp;uin=21306562&amp;site=qq&amp;menu=yes">QQ 21306562</a></li>
                </div>
                ',
                'style' => 'warning',
                'type' => 'submessage',
            ) ,
            
            array(
                'id'      => 'enable_collection',
                'type'    => 'switcher',
                'title'   => '启用采集',
                'default' => true,
                'desc'    => '开启后，系统将全局采集文章。',
            ),
            
            
            
            
             array(
                'id'    => 'api_settings',
                'type'  => 'group',
                'title' => '采集接口配置',
                'fields' => array(
                    array(
                        'id'    => 'api_name',
                        'type'  => 'text',
                        'title' => '接口名称',
                        'desc'  => '输入主站接口的名称，例如 资源站, 软件站,图片站',
                    ),
                    array(
                        'id'    => 'key',
                        'type'  => 'text',
                        'title' => '授权码',
                        'desc'  => '<div style="color:#ff4021;"><i class="fa fa-fw fa-info-circle fa-fw"></i>请正确填写否则无法采集文章数据</div>',
                    ),
                    array(
                        'id'    => 'custom_domain',
                        'type'  => 'text',
                        'title' => '主站接口',
                        'default' => 'https://www.16yc.cn',
                        'desc'  => '<div style="color:#ff4021;"><i class="fa fa-fw fa-info-circle fa-fw"></i> 请输入主站域名接口，例如 <strong>https://www.16yc.cn</strong>，不要带/，如不清楚请联系站长咨询</div>',
                    ),
                    array(
                        'id'    => 'enable_collection',
                        'type'  => 'switcher',
                        'title' => '启用采集',
                        'default' => true,
                        'desc'  => '开启后，将单独控制站点是否采集。',
                    ),
                ),
            ),
        
        array(
            'id'      => 'enable_access',
            'type'    => 'switcher',
            'title'   => '更新频率',
            'default' => false,
            'desc'    => '开启后，可以设置更新频率时间。由于wordpress的Corn任务限制，如果站点流量不大，请在宝塔设置更新频率',
        ),
        array(
            'id'    => 'access_frequency',
            'type'  => 'text',
            'title' => '更新频率时间',
            'default' => '2', // 默认值为60
            'desc'    => '<div style="color:#ff4021;"><i class="fa fa-fw fa-info-circle fa-fw"></i> 请输入更新频率时间，默认是2分。请根据自身情况选择时间单位！</div>',
            'dependency' => array('enable_access', '==', 'true'),
        ),
        array(
            'id'      => 'access_time_unit',
            'type'    => 'select',
            'title'   => '时间单位',
            'options' => array(
                // 'seconds' => '秒',
                'minutes' => '分钟',
                'hours'   => '小时',
            ),
            'desc'    => '请选择更新频率的时间单位。',
            'default' => 'minutes', 
            'dependency' => array('enable_access', '==', 'true'), 
            
        ),

            array(
                'title'      => '采集池接口',
                'id'         => 'api',
                'default'    => 'zb/v1',
                'type'       => 'text',
                'class'      => 'mini-input',
                'attributes' => array(
                    'data-readonly-id' => 'product_slug',
                    'readonly'         => 'readonly',
                ),
                'desc'       => '<div style="color:#ff4021;"><i class="fa fa-fw fa-info-circle fa-fw"></i>需要和采集站插件路由保持一致 否则分站无法获取采集站文章数据</div>
            <br><a href="javascript:;" class="but jb-yellow remove-readonly" readonly-id="product_slug">修改路由</a>',
            ),
     
    ),
));
    
    CSF::createSection($prefix, array(
        'parent'      => 'posts',
        'title'       => '文章&配置',
        'icon'        => 'fa fa-link',
        'description' => '',
        'fields'      => array(
            array(
                'content' => '<h3 style="color:#fd4c73;"><i class="fa fa-heart fa-fw"></i> 感谢您使用易采集</h3>
                <div style="margin: 10px 14px;">
                <li>本页面由易创技术网制作，请在使用时遵守原作者的版权规定</li>
                <li>官网：<a target="_bank" href="https://www.16yc.cn/">https://www.16yc.cn/</a></li>
                <li>作者联系方式：<a target="_bank" href="http://wpa.qq.com/msgrd?v=3&amp;uin=21306562&amp;site=qq&amp;menu=yes">QQ 21306562</a></li>
                </div>
                ',
                'style' => 'warning',
                'type' => 'submessage',
            ) ,
            
            
                        array(
                'id'      => 'enable_sort_by_time', // 新增的开关
                'type'    => 'switcher',
                'title'   => '按照时间排序采集文章',
                'default' => false,
                'desc'    => '开启后，系统将按照文章发布时间排序采集文章。',
            ),
          
 
            array(
                'id'      => 'post_status',
                'type'    => 'select',
                'title'   => '文章发布状态',
                'options' => array(
                    'publish' => '直接发布',
                    'draft'   => '保存为草稿',
                ),
                'default' => 'publish',
                'desc'    => '选择文章采集后的状态。',
            ),
            

            
            array(
                'id'           => 'conversion',
                'type'         => 'group',
                'title'        => '分类替换',
                'fields'       => array(
                    array(
                        'id'    => 'find',
                        'type'  => 'text',
                        'title' => '查找',
                        'desc'    => '<div style="color:#ff4021;">请输入完整名称 否则无法替换</div>',
                    ),
                    array(
                        'id'    => 'replacement',
                        'type'  => 'text',
                        'title' => '替换',
                    ),
                ),
            ),
			
			            array(
                'id'          => 'search_more_cat_obj',
                'title'       => '黑名单分类',
                'default'     => '',
                'desc'        => '添加黑名单分类后 同步的文章分类如有包含则不会发布文章',
                'placeholder' => '黑名单分类',
                'options'     => 'categories',
                'type'        => 'select',
                'chosen'      => true,
                'multiple'    => true,
                'sortable'    => true,
            ),               
               

    // 		array(
    // 		    'id' => 'user',
    // 		    'type' => 'select',
    // 		    'title' => '<span style="color: red;">自定义文章作者</span>',
    // 		    'placeholder' => '选择用户',
    // 		    'chosen' => true,
    // 		    'multiple' => true,
    // 		    'ajax' => true,
    //             'settings'    => array(
    //                 'min_length' => 2,
    //             ),
    // 		    'options' => 'users',
    // 		    'desc' => '<span style="color: red;">请务必选择作者，否则文章可能出错。如若选择多个作者则同步到的文章作者将会随机分配</span>',
    // 		) ,
    		
    		
            array(
                'id'          => 'user',
                'type'        => 'select',
                'title'       => '<span style="color: red;">自定义文章作者</span>',
                'placeholder' => '选择用户',
                'chosen'      => true,
                'multiple'    => true,
                'ajax'        => true,
                'settings'    => array(
                    'min_length' => 2,
                ),
                'options'     => 'users',
                'desc'        => '<span style="color: red;">如若选择多个作者则同步到的文章作者将会随机分配</span>',
                'after'       => '<p style="color: blue; margin-top:5px;">(说明：请务必填写文章作者)</p>',
            ),	
                		
                		
    		
    		

                		
            array(
                'title' => '自定义金额（随机分配）',
                'id' => 'random_fixed_money',
                'default' => '6.8,9.9,12.9,19.9',
                'desc' => __('输入多个金额，用逗号分隔（例如：6.8,9.9,12.9,19.9），系统会随机选择一个金额', 'zib_language'),
                'type' => 'text',
               ),

            array(
                'title'   => '是否本地化图片',
                'label'   => '开启后，同步到的文章内容中的图片将会本地化并替换掉原本链接',
                'id'      => 'img_url',
                'type'    => 'switcher',
                'default' => true,
            ),
            
            array(
                'title'   => '禁用生成缩略图',
                'label'   => '开启后，将禁用文章的缩略图生成,减轻服务器压力及空间',
                'id'      => 'disable_thumbnail',
                'type'    => 'switcher',
                'default' => true,
            ),

    
            array(
                'id'      => 'empty_space_1',
                'type'    => 'content',
                'content' => '<div style="height: 20px;"></div>', 
            ),
            array(
                'id'      => 'empty_space_2',
                'type'    => 'content',
                'content' => '<div style="height: 20px;"></div>', 
            ),
            array(
                'id'      => 'empty_space_3',
                'type'    => 'content',
                'content' => '<div style="height: 20px;"></div>',
            ),
            		
                    
                    ),
                ));
                
        
        
        
     $options = get_option($prefix);
    error_log('Current Options: ' . print_r($options, true)); // 添加调试输出

    CSF::createSection($prefix, array(
        'id' => 'tg',
        'title' => '推广&功能',
        'icon' => 'fa fa-link'
    ));

 // 创建推广功能的设置部分，放在系统&环境下面
    CSF::createSection($prefix, array(
        'id' => 'promotion',
        'title' => '推广&功能',
        'parent' => 'tg', 
        'icon' => 'fa fa-fw fa-fw fa-magic',
        'description' => '',
        'default' => true,
        'fields' => array(
             array(
                'content' => '<h3 style="color:#fd4c73;"><i class="fa fa-heart fa-fw"></i> 感谢您使用易采集</h3>
                <div style="margin: 10px 14px;">
                <li>本页面由易创技术网制作，请在使用时遵守原作者的版权规定</li>
                <li>官网：<a target="_bank" href="https://www.16yc.cn/">https://www.16yc.cn/</a></li>
                <li>作者联系方式：<a target="_bank" href="http://wpa.qq.com/msgrd?v=3&amp;uin=21306562&amp;site=qq&amp;menu=yes">QQ 21306562</a></li>
                </div>
                ',
                'style' => 'warning',
                'type' => 'submessage',
            ) ,
            
            
            
            array(
                'id'      => 'posts_activity',
                'type'    => 'switcher',
                'label'   => '设置后 可以在发布文章的时候选择是否通过推广免费获取付费内容',
                'default' => false,
                'title'   => '文章限时活动',
            ),
            array(
                'dependency' => array('posts_activity', '!=', ''),
                'id'          => 'posts_activity_cats',
                'title'       => '自定义开启活动分类',
                'desc'        => '输入关键词以搜索分类',
                'default'     => '',
                'options'     => 'categories',
                'placeholder' => '输入关键词以搜索分类',
                'chosen'      => true,
                'ajax'        => true,
                'multiple'    => true,
                'settings'    => array(
                    'min_length' => 2,
                ),
                'type'        => 'select',
            ),
            array(
                'dependency' => array('posts_activity', '!=', ''),
                'title'   => '模块显示位置',
                'id'      => 'activity_box_position',
                'default' => 'top',
                'type'    => "radio",
                'desc'    => "在文章页面中活动推广的显示位置",
                'options' => array(
                    'box_top'    => __('文章模块上方', 'zib_language'),
                    'top'        => __('文章内容顶部', 'zib_language'),
                    'bottom'     => __('文章内容底部', 'zib_language'),
                    'box_bottom' => __('文章模块下方', 'zib_language'),
                ),
            ),
            array(
                'dependency' => array('posts_activity', '!=', ''),
                'id'    => 'activity_title',
                'type'  => 'text',
                'title' => '模块标题',
                'default' => '限时活动',
            ),
            array(
                'dependency' => array('posts_activity', '!=', ''),
                'id'    => 'activity_tips',
                'class' => 'compact',
                'type'  => 'text',
                'title' => '温馨提示',
                'default' => '将其粘贴到贴吧、论坛，或者微信群、QQ群，只要有8人点击了你的推广链接，你就可以免费查看这篇文章啦！',
            ),
            array(
                'dependency' => array('posts_activity', '!=', ''),
                'title'    => __('推广个数', 'zib_language'),
                'id'       => 'activity_number',
                'desc'     => __('此处仅为预设 具体按文章数据来判断', 'zib_language'),
                'default'  => '8',
                'type'     => 'number',
                'unit'     => '次',
            ),
            array(
                'dependency' => array('posts_activity', '!=', ''),
                'title'    => __('奖励有效期', 'zib_language'),
                'id'       => 'activity_time',
                'default'  => '5',
                'class' => 'compact',
                'type'     => 'number',
                'unit'     => '天',
            ),
            
            array(
                'dependency' => array('posts_activity', '!=', ''),
                'title'    => __('活动有效期', 'zib_language'),
                'id'       => 'activity_date',
                'class' => 'compact',
                'default'  => '',
                'desc'       => '<p>留空则为永久有效</code>',
                'type'     => 'date',
                'settings'   => array(
                    'dateFormat'  => 'yy-mm-dd 23:59:59',
                    'changeMonth' => true,
                    'changeYear'  => true,
                ),
            ),
            
            array(
                'id'      => 'empty_space_1',
                'type'    => 'content',
                'content' => '<div style="height: 20px;"></div>', 
            ),
            array(
                'id'      => 'empty_space_2',
                'type'    => 'content',
                'content' => '<div style="height: 20px;"></div>', 
            ),
            array(
                'id'      => 'empty_space_3',
                'type'    => 'content',
                'content' => '<div style="height: 20px;"></div>',
            ),
            	
        ),
    ));  
    
        

                
    
    CSF::createSection($prefix, array(
        'id'    => 'xt',
        'title' => '系统&环境',
        'icon'  => 'fa fa-fw fa-gitlab',
        'fields'      => array(
            array(
                'content' => '<h3 style="color:#fd4c73;"><i class="fa fa-heart fa-fw"></i> 感谢您使用易采集</h3>
                <div style="margin: 10px 14px;">
                <li>本页面由易创技术网制作，请在使用时遵守原作者的版权规定</li>
                <li>官网：<a target="_bank" href="https://www.16yc.cn/">https://www.16yc.cn/</a></li>
                <li>作者联系方式：<a target="_bank" href="http://wpa.qq.com/msgrd?v=3&amp;uin=21306562&amp;site=qq&amp;menu=yes">QQ 21306562</a></li>
                </div><div style="margin-left:14px;"><li><strong>操作系统</strong>： ' . PHP_OS . ' </li>
            <li><strong>运行环境</strong>： ' . $_SERVER["SERVER_SOFTWARE"] . ' </li>
            <li><strong>PHP版本</strong>： ' . PHP_VERSION . ' </li>
            <li><strong>WordPress版本</strong>： ' . get_bloginfo('version') . '</li>
            <li><strong>系统信息</strong>： ' . php_uname() . ' </li>
            <li><strong>服务器时间</strong>： ' . current_time('mysql') . '</li></div>
            <a class="but c-yellow" href="' . admin_url('site-health.php?tab=debug') . '">查看更多系统信息</a>
                ',
                'style' => 'warning',
                'type' => 'submessage',
            ) ,
        ),
    ));    
    
}

