<?php

if (!defined('ABSPATH')) {
    exit;
}

mk_article_links_clicks_table();

// 创建文章推广数据表
function mk_article_links_clicks_table() 
{
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $table_name = $wpdb->prefix . 'mk_posts_links';

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        `id` INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        `post_id` INT(11) NOT NULL COMMENT '关联的文章ID',
        `short_code` VARCHAR(255) NOT NULL UNIQUE COMMENT '短链接代码',
        `click_count` INT(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '点击次数',
        `target_clicks` INT(11) UNSIGNED NOT NULL DEFAULT '0' COMMENT '目标点击量',
        `all_clicked_ips` TEXT DEFAULT NULL COMMENT '所有点击的IP地址列表',
        `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
        `created_by` INT(11) NOT NULL COMMENT '创建者的用户ID',
        `status` INT(11) NOT NULL COMMENT '0.未使用 1.已使用'
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}


// 创建文章唯一哈希记录表，用于重复检测
function mk_collection_hash_table() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $table_name = $wpdb->prefix . 'collection_hash';

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        post_id INT(11) NOT NULL,
        article_hash VARCHAR(64) NOT NULL UNIQUE COMMENT '文章哈希',
        created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP
    ) $charset_collate;";
    
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}


/**
 * 创建用于图片缓存的数据库表
 */
function zibpost_create_image_cache_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'zibpost_image_cache';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE {$table_name} (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        original_url VARCHAR(1024) NOT NULL,
        local_url VARCHAR(1024) NOT NULL,
        last_update DATETIME NOT NULL,
        retry_count INT(11) DEFAULT 0,
        status TINYINT(1) DEFAULT 0, -- 0: 待处理, 1: 成功, -1: 失败
        PRIMARY KEY (id),
        UNIQUE KEY original_url (original_url(255))
    ) {$charset_collate};";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

