<?php
/*
plugin name: 易采集
plugin URI: https://www.16yc.cn/
description: 易采集-全网的虚拟资源，每天自动同步到自己网站，解决站长到处找资源的烦恼，以及节省站长的宝贵的时间
author: 易创网
author URI: https://www.16yc.cn/
version: 1.2.0
*/

if ( ! function_exists('zibpost')) 
{
    /*
    *主题核心变量 修改就爆炸！
    */
    function zibpost( $option = '', $default = null ) 
    {
        $options = get_option('zibpost'); // Attention: Set your unique id of the framework
        return ( isset( $options[$option] ) ) ? $options[$option] : $default;
    }
}

function article($key, $default = null) {
    $options = get_option('zibpost'); // 假设您在选项中存储了相关数据
    return isset($options[$key]) ? $options[$key] : $default;
}


require  plugin_dir_path(__FILE__) .'inc/inc.php';
/**
 * 插件启动时执行函数
 */
register_activation_hook(__FILE__, 'zibpostss');
add_action('admin_init', 'zibpost_plugin');
function zibpostss() 
{
    add_option('zibpostss', true);
}

function zibpost_plugin() 
{
    if (get_option('zibpostss', false)) {
        delete_option('zibpostss');
        wp_redirect(admin_url( 'admin.php?page=zibpost' ));
    }
}

register_activation_hook(__FILE__, 'zibpost_add_db_indexes');
function zibpost_add_db_indexes() {
    global $wpdb;
    $table_name = $wpdb->posts;
    $index_name = 'idx_post_name';

    // 检查索引是否已存在
    $index_exists = $wpdb->get_var($wpdb->prepare(
        "SHOW INDEX FROM $table_name WHERE Key_name = %s",
        $index_name
    ));

    if (!$index_exists) {
        $wpdb->query("ALTER TABLE `$table_name` ADD INDEX `$index_name` (`post_name`)");
    }
    
        // 创建自定义哈希记录表
    if (function_exists('mk_collection_hash_table')) {
        mk_collection_hash_table();
    }
    
    
}

register_deactivation_hook(__FILE__, 'zibpost_remove_db_indexes');
function zibpost_remove_db_indexes() {
    global $wpdb;
    $table_name = $wpdb->posts;
    $index_name = 'idx_post_name';

    $wpdb->query("ALTER TABLE `$table_name` DROP INDEX `$index_name`");
}



function correct_pay_cuont_spelling($meta_id, $post_id, $meta_key, $_meta_value) {
    if ($meta_key === 'posts_zibpay') {
        if (isset($_meta_value['pay_count']) && !isset($_meta_value['pay_cuont'])) {
            $_meta_value['pay_cuont'] = $_meta_value['pay_count'];
            unset($_meta_value['pay_count']);
            update_post_meta($post_id, 'posts_zibpay', $_meta_value);
        }
    }
}
add_action('updated_post_meta', 'correct_pay_cuont_spelling', 10, 4);
add_action('added_post_meta', 'correct_pay_cuont_spelling', 10, 4);

// 插件激活时创建图片缓存数据库表
register_activation_hook(__FILE__, 'zibpost_create_image_cache_table');
?>


